<?php


abstract class VerifoneAbstarctModuleFrontController extends ModuleFrontController
{
    /** @var string module name */
    public $name = 'verifone';

    /** @var  array Contain ajax response. */
    public $jsonValues;

    /** @var  array  POST and GET values defined in init function */
    public $request;

    /** @var  string Contain redirect URL.. */
    public $redirectUrl;

    /** @var Array containing errors */
    public $errors;

    /**
     * @throws PrestaShopException
     * @see ModuleFrontController::run
     */
    public function run()
    {
        $this->init();
        if ($this->checkAccess()) {
            $this->postProcess();
        }

        if ( ! empty($this->redirectUrl)) {
            $this->redirectWithNotifications($this->redirectUrl);
        }
    }

    public function transformFromCents($inputPrice, $precision)
    {
        $cents_as_int = (int) $inputPrice;

        return $cents_as_int / pow(10, $precision);
    }

    /**
     * adds private message to order
     *
     * @param $order
     * @param $note
     *
     * @return bool
     */
    public function addOrderNote($order, $note)
    : bool {
        try {

            $admin  = Db::getInstance()->getRow('SELECT id_employee from '._DB_PREFIX_.'employee ORDER BY id_employee ASC');
            $thread = Db::getInstance()->getRow('SELECT id_customer_thread from '._DB_PREFIX_.'customer_thread WHERE id_order = '.$order->id.' AND id_shop ='.$this->context->shop->id);
            if ($thread) {
                $threadId = $thread['id_customer_thread'];
            } else {
                $now = date('Y-m-d H:i:s');
                $cnt = $this->context;

                $thread              = new CustomerThread();
                $thread->id_shop     = $cnt->shop->id;
                $thread->id_lang     = $cnt->language->id;
                $thread->id_contact  = 0;
                $thread->id_customer = $order->id_customer;
                $thread->id_order    = $order->id;
                $thread->id_product  = 0;
                $thread->status      = 'open';
                $thread->email       = $order->getCustomer()->email;
                $thread->date_add    = $now;
                $thread->token       = substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyzQWERTYUIOPLKJHGFDSAZXCVBNM"), 0, 12);;
                $thread->date_upd = $now;

                $thread->save();
                $threadId = $thread->id;
            }

            $message                     = new CustomerMessage();
            $message->id_order           = $order->id;
            $message->id_employee        = $admin['id_employee'];
            $message->id_customer_thread = $threadId;
            $message->message            = $note;
            $message->private            = true;

            return $message->save();

        } catch (Exception $exception) {
            (new Verifone_Cart_Logger())->error($exception->getMessage());

            return false;
        }

    }

    /**
     * @param  string  $string
     * @param  array  $params
     *
     * @return string
     */
    public function transalate(string $string, array $params = [])
    : string {
        return $this->trans($string, $params, 'Modules.Verifone.Payments');
    }

}
