<?php

use Symfony\Component\HttpFoundation\JsonResponse;
use VerifoneEcomAPI\ApiWrapper\Http\AutoSetupService;
use VerifoneEcomAPI\ApiWrapper\Settings;


/**
 * Class VerifonePaymentCallbackModuleFrontController
 */
class VerifoneAutoSetupModuleFrontController extends ModuleFrontController
{
    private AutoSetupService $service;

    public function init()
    {
        parent::init();
        $this->request = Tools::getAllValues();
        $this->service = new AutoSetupService($this->request);
    }


    /**
     * @return string
     * @throws Exception
     */
    public function postProcess(): string
    {
        $result = $this->service->setAccount();

        $response = new JsonResponse();
        $response->setStatusCode($result['status'] ? 200 : 412);
        $response->setData($result);

        return $response->send();
    }
}
