<?php


use VerifoneEcomAPI\ApiWrapper\Authentication\BasicAuth;
use VerifoneEcomAPI\ApiWrapper\Http\ApiClient\Client;
use VerifoneEcomAPI\ApiWrapper\Http\SimpleCurl;
use VerifoneEcomAPI\ApiWrapper\Regions\Au;
use VerifoneEcomAPI\ApiWrapper\Regions\Emea;
use VerifoneEcomAPI\ApiWrapper\Regions\Na;
use VerifoneEcomAPI\ApiWrapper\Regions\NzAu;
use VerifoneEcomAPI\ApiWrapper\Settings;

require_once 'abstract.php';

class VerifoneCaptureModuleFrontController extends VerifoneAbstarctModuleFrontController
{


    public $verifone;
    public $order;
    public $request;

    // make sure only admin is allowed here and come from Verifone module
    private $client;
    /**
     * @var Settings
     */
    private $verifone_settings;
    /**
     * @var Verifone_Cart_Logger
     */
    private $logger;
    /**
     * @var SimpleCurl
     */
    private $simple_curl;
    /**
     * @var Emea|Na|NzAu|Au
     */
    private $mapper;

    public function init()
    {
        $this->verifone_settings = new Settings();
        $this->logger = new Verifone_Cart_Logger();
        $this->simple_curl = new SimpleCurl();

        // mini factory :D
        switch ($this->verifone_settings->getRegion()) {
            case 'AU':
                $this->mapper = new Au($this->verifone_settings);
                break;
            case 'NZAU':
                $this->mapper = new NzAu($this->verifone_settings);
                break;
            case 'NA':
                $this->mapper = new Na($this->verifone_settings);
                break;
            default:
                $this->mapper = new Emea($this->verifone_settings);
                break;
        }

        $this->auth = new BasicAuth($this->verifone_settings);
        $this->client = new Client($this->mapper, $this->verifone_settings, $this->auth, $this->simple_curl);

        $this->request = Tools::getAllValues();
        $cookie = new Cookie('psAdmin', '', (int)Configuration::get('PS_COOKIE_LIFETIME_BO'));
        $employee = new Employee((int)$cookie->id_employee);
        if (Validate::isLoadedObject($employee) &&
            $employee->checkPassword((int)$cookie->id_employee, $cookie->passwd)
            && (!isset($cookie->remote_addr) ||
                $cookie->remote_addr == ip2long(Tools::getRemoteAddr()) ||
                !Configuration::get('PS_COOKIE_CHECKIP')
            ) && $this->request['module'] === $this->name && !empty($this->request['type'])
        ) {
            // continue with request
        } else {
            exit('not allowed');
        }
    }


    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function postProcess(): array
    {


        if ($this->request['module'] !== $this->name ||
            empty($this->request['transaction_id']) ||
            empty($this->request['order_id']) ||
            !in_array($this->request['type'], ['partial', 'full'])) {

            exit(json_encode([
                'status' => false,
                'message' => 'Invalid params'
            ]));
        }

        try {
            $this->order = new Order((int)$this->request['order_id']);
            $amount = $this->request['type'] === 'full' ? $this->order->total_paid : $this->request['amount'];
            $stringAmount = (string)($amount * 100);

            $transaction = $this->client->getTransaction($this->request['transaction_id']);

            if ($transaction['payment_product'] === 'PayPal') {
                $payload = [
                    'amount' => [
                        'value' => (int)$stringAmount,
                        'currencyCode' => $transaction['currency_code']
                    ]
                ];
            } else {
                $payload = ['amount' => (int)$stringAmount];
            }

            $response = $this->client->postCapture($payload, $transaction['id'], $transaction['payment_product'] ?? null);
            if (isset($response['status']) && in_array($response['status'], ['AUTHORISED', 'AUTHORIZED','SETTLEMENT_COMPLETED'])) {
                if ((int)Configuration::get('VERIFONE_ORDER_STATUS') != $this->order->current_state) {
                    $history = new OrderHistory();
                    $history->id_order = (int)$this->order->id;
                    $history->changeIdOrderState((int)Configuration::get('VERIFONE_ORDER_STATUS'), $this->order, true);
                    $history->save();
                }
                exit(json_encode([
                    'status' => true,
                    'message' => 'Amount (' . number_format($amount, 2) . $transaction['currency_code'] . ') captured with success'
                ]));
            }
            $this->addOrderNote($this->order, 'Capture request for ' . number_format($amount, 2) . $transaction['currency_code'] . ' amount failed');
            exit(json_encode([
                'status' => false,
                'message' => $response['details']['type'] ?? 'Something went wrong',
                'verifone_response' => $response
            ]));
        } catch (Exception $exception) {
            $this->addOrderNote($this->order, 'Capture request failed: ' . $exception->getMessage());

            exit(json_encode([
                'status' => false,
                'message' => $exception->getMessage()
            ]));
        }
    }


}
