<?php

require_once 'abstract.php';

/**
 * Class VerifoneGenerateUrlModuleFrontController
 */
class VerifoneGenerateUrlModuleFrontController extends VerifoneAbstarctModuleFrontController
{

    protected $method;

    /**
     * @throws PrestaShopException
     */
    public function postProcess()
    {
        $authorized = false;

        try {
            $module_name = Tools::getValue('module_name');

            if ( ! $module_name) {
                $msg = $this->l('Invalid module name in Generate Url controller');
                throw new PrestaShopException($msg);
            }
            $this->module = Module::getInstanceByName($module_name);
            $cart         = $this->context->cart;
            if ( ! $this->module->active || $cart->id_customer == 0 || $cart->id_address_delivery == 0
                 || $cart->id_address_invoice == 0) {
                Tools::redirect('index.php?controller=order&step=1');
            }
            foreach (Module::getPaymentModules() as $module) {
                if ($module['name'] == 'verifone') {
                    $authorized = true;
                    break;
                }
            }

            if ( ! $authorized) {
                die($this->l('This payment method is not available.'));
            }

            $customer = new Customer($cart->id_customer);
            if ( ! Validate::isLoadedObject($customer)) {
                Tools::redirect('index.php?controller=order&step=1');
            }
            //Check if live&test accounts passwords are set
            if ( ! $this->module->verifone_settings->getUserId()
                 || ! $this->module->verifone_settings->getApiKey()) {
                throw new PrestaShopException('User ID or Api Key is missing! Please check module configuration.');
            }

            $verifone_customer = new Verifone_Customer(['cart' => $cart, 'customer' => $customer], $this->module->verifone_settings);

            $result            = $this->module->client->postCustomer($verifone_customer->toArray());
            $customer_id       = $result['id'];
            $returnUrl         = $this->context->link->getModuleLink($this->module->name, 'paymentCallback',
                [
                    'id_cart'   => $cart->id,
                    'id_module' => (int) $this->module->id,
                    'key'       => $customer->secure_key
                ],
                true);
            $params            = [
                'cart'      => $cart,
                'currency'  => $this->context->currency,
                'returnUrl' => $returnUrl
            ];

            $verifone_checkout = new Verifone_Checkout(
                $params,
                $this->module->verifone_settings,
                $this->module->verifone_helper,
                $customer_id);
            $result            = $this->module->client->postCheckout($verifone_checkout->toArray());
            if ( ! isset($result['url'])) {
                throw new PrestaShopException(sprintf($this->l('We encountered an error! API response: %s'), json_encode($result)));
            }
            $response = ['success' => true, 'redirect_link' => $result['url'], 'type' => $this->module->verifone_settings->getCheckoutType()];

        } catch (Exception $e) {
            (new Verifone_Cart_Logger())->error('Error generating url: '.$e->getMessage());
            Context::getContext()->cookie->__set('redirect_error', $this->l('We encountered an error while connecting to Verifone.'));
            Context::getContext()->cookie->write();
            $response            = [
                'success'       => false,
                'status'        => 'error',
                'redirect_link' => Context::getContext()->link->getPageLink('cart', null, null, ['action' => 'show'])
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }
}
