<?php

namespace VerifoneEcomAPI\ApiWrapper;

use Configuration;
use PrestaShopLogger;

/**
 * Class Settings
 * @package VerifoneEcomAPI\ApiWrapper
 */
class Settings
{

    private $testMode;
    private $apiKey;
    private $userId;
    private $entityId;
    private $region;
    private $title;
    private $description;
    private $cardEnabled;
    private $paymentContractId;
    private $threeDSEnabled;
    private $threeDSContractId;
    private $curlVerifySSL;
    private $checkoutType;
    private $paypalEnabled;
    private $paypalContractId;
    private $themeId;
    private $applePayEnabled;
    private $applePaySCALevel;
    private $applePayContractId;
    private $applePayThreeDSContractId;
    private $googlePayEnabled;
    private $klarnaPayEnabled;
    private $googlePaySCALevel;
    private $googlePayContractId;
    private $googlePayThreeDSContractId;
    private $cardFraudProtectionEnabled;
    private $cardFraudProtectionContractId;
    private $transactionType;
    private $swishEnabled;
    private $vippsEnabled;
    private $vippsSCALevel;
    private $vippsContractId;
    private $vippsThreeDSContractId;
    private $giftCardEnabled;
    private $giftCardContractId;
    private $gpp2Enabled;
    private $gpp2ContractId;
    private $mobilePayEnabled;
    private $mobilePaySCALevel;
    private $mobilePayContractId;
    private $mobilePayThreeDSContractId;
    private $absInstallments;
    private $absInstallmentsEnabled;
    private $orderStatus;
    private $plccEnabled;
    private $plccContractId;
    private $bankOpEnabled;
    private $bankOpContractId;


    public function __construct()
    {
        $this->testMode = Configuration::get('VERIFONE_MODE');
        $this->apiKey = Configuration::get('VERIFONE_API_KEY');
        $this->userId = Configuration::get('VERIFONE_USER_ID');
        $this->entityId = Configuration::get('VERIFONE_ENTITY_ID');
        $this->region = Configuration::get('VERIFONE_REGION');
        $this->title = Configuration::get('VERIFONE_TITLE');
        $this->description = Configuration::get('VERIFONE_DESCRIPTION');
        $this->cardEnabled = Configuration::get('VERIFONE_CARD_ENABLED');
        $this->paymentContractId = Configuration::get('VERIFONE_PAYMENT_CONTRACT_ID');
        $this->threeDSEnabled = Configuration::get('VERIFONE_3DS_ENABLED');
        $this->threeDSContractId = Configuration::get('VERIFONE_3DS_CONTRACT_ID');
        $this->curlVerifySSL = Configuration::get('VERIFONE_CURL_VERIFY_SSL');
        $this->checkoutType = Configuration::get('VERIFONE_CHECKOUT_TYPE');
        $this->paypalEnabled = Configuration::get('VERIFONE_PAYPAL_ENABLED');
        $this->paypalContractId = Configuration::get('VERIFONE_PAYPAL_CONTRACT_ID');
        $this->themeId = Configuration::get('VERIFONE_THEME_ID');
        $this->applePayEnabled = Configuration::get('VERIFONE_APPLE_PAY_ENABLED');
        $this->applePayContractId = Configuration::get('VERIFONE_APPLE_PAY_CONTRACT_ID');
        $this->applePayThreeDSContractId = Configuration::get('VERIFONE_APPLE_PAY_THREE_DS_CONTRACT_ID');
        $this->applePaySCALevel = Configuration::get('VERIFONE_APPLE_PAY_SCA_LEVEL');
        $this->googlePayEnabled = Configuration::get('VERIFONE_GOOGLE_PAY_ENABLED');
        $this->klarnaPayEnabled = Configuration::get('VERIFONE_KLARNA_ENABLED');
        $this->googlePayContractId = Configuration::get('VERIFONE_GOOGLE_PAY_CONTRACT_ID');
        $this->googlePayThreeDSContractId = Configuration::get('VERIFONE_GOOGLE_PAY_THREE_DS_CONTRACT_ID');
        $this->googlePaySCALevel = Configuration::get('VERIFONE_GOOGLE_PAY_SCA_LEVEL');
        $this->transactionType = Configuration::get('VERIFONE_TRANSACTION_TYPE');
        $this->cardFraudProtectionEnabled = Configuration::get('VERIFONE_CARD_FRAUD_PROTECTION_ENABLED');
        $this->cardFraudProtectionContractId = Configuration::get('VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID');
        $this->swishEnabled = Configuration::get('VERIFONE_SWISH_ENABLED');
        $this->vippsEnabled = Configuration::get('VERIFONE_VIPPS_ENABLED');
        $this->vippsContractId = Configuration::get('VERIFONE_VIPPS_CONTRACT_ID');
        $this->vippsThreeDSContractId = Configuration::get('VERIFONE_VIPPS_THREE_DS_CONTRACT_ID');
        $this->vippsSCALevel = Configuration::get('VERIFONE_VIPPS_SCA_LEVEL');
        $this->gpp2Enabled = Configuration::get('VERIFONE_GPP2_ENABLED');
        $this->gpp2ContractId = Configuration::get('VERIFONE_GPP2_CONTRACT_ID');
        $this->mobilePayEnabled = Configuration::get('VERIFONE_MOBILE_PAY_ENABLED');
        $this->mobilePayContractId = Configuration::get('VERIFONE_MOBILE_PAY_CONTRACT_ID');
        $this->mobilePayThreeDSContractId = Configuration::get('VERIFONE_MOBILE_PAY_THREE_DS_CONTRACT_ID');
        $this->mobilePaySCALevel = Configuration::get('VERIFONE_MOBILE_PAY_SCA_LEVEL');
        $this->absInstallmentsEnabled = Configuration::get('VERIFONE_ABS_INSTALLMENTS_ENABLED');
        $this->absInstallments = Configuration::get('VERIFONE_ABS_INSTALLMENTS');
        $this->orderStatus = Configuration::get('VERIFONE_ORDER_STATUS');

        $this->giftCardEnabled = Configuration::get('VERIFONE_GIFT_CARD_ENABLED');
        $this->giftCardContractId = Configuration::get('VERIFONE_GIFT_CARD_CONTRACT_ID');
        $this->plccEnabled = Configuration::get('VERIFONE_PLCC_ENABLED');
        $this->plccContractId = Configuration::get('VERIFONE_PLCC_CONTRACT_ID');
        $this->bankOpEnabled = Configuration::get('VERIFONE_BANK_OP_ENABLED');
        $this->bankOpContractId = Configuration::get('VERIFONE_BANK_OP_CONTRACT_ID');
    }

    public function set($key, $value)
    {
        $this->$key =$value;
        return $this;
    }

    /**
     * @return false|string
     */
    public function getBankOpEnabled()
    {
        return $this->bankOpEnabled;
    }

    /**
     * @return false|string
     */
    public function getBankOpContractId()
    {
        return $this->bankOpContractId;
    }
    /**
     * @return false|string
     */
    public function getPlccEnabled()
    {
        return $this->plccEnabled;
    }

    /**
     * @return false|string
     */
    public function getPlccContractId()
    {
        return $this->plccContractId;
    }

    /**
     * @return bool
     */
    public function isTest(): bool
    {
        return $this->testMode !== 'live';
    }

    /**
     * @return false|string
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }

    /**
     * @return false|string
     */
    public function getApplePayEnabled()
    {
        return $this->applePayEnabled;
    }

    /**
     * @return false|string
     */
    public function getApplePaySCALevel()
    {
        return $this->applePaySCALevel;
    }

    /**
     * @return false|string
     */
    public function getApplePayContractId()
    {
        return $this->applePayContractId;
    }

    /**
     * @return false|string
     */
    public function getApplePayThreeDSContractId()
    {
        return $this->applePayThreeDSContractId;
    }

    /**
     * @return false|string
     */
    public function getGooglePayEnabled()
    {
        return $this->googlePayEnabled;
    }

    /**
     * @return false|string
     */
    public function getSwishEnabled()
    {
        return $this->swishEnabled;
    }

    /**
     * @return false|string
     */
    public function getKlarnaEnabled()
    {
        return $this->klarnaPayEnabled;
    }

    /**
     * @return false|string
     */
    public function getGooglePaySCALevel()
    {
        return $this->googlePaySCALevel;
    }

    /**
     * @return false|string
     */
    public function getGooglePayContractId()
    {
        return $this->googlePayContractId;
    }

    /**
     * @return false|string
     */
    public function getGooglePayThreeDSContractId()
    {
        return $this->googlePayThreeDSContractId;
    }

    /**
     * @return false|string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }

    /**
     * @return false|string
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @return false|string
     */
    public function getEntityId()
    {
        return $this->entityId;
    }

    /**
     * @return false|string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @return false|string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @return false|string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return false|string
     */
    public function getCardEnabled()
    {
        return $this->cardEnabled;
    }

    /**
     * @return false|string
     */
    public function getPaymentContractId()
    {
        return $this->paymentContractId;
    }

    /**
     * @return false|string
     */
    public function getThreeDSEnabled()
    {
        return $this->threeDSEnabled;
    }

    /**
     * @return false|string
     */
    public function getThreeDSContractId()
    {
        return $this->threeDSContractId;
    }

    /**
     * @return false|string
     */
    public function getCurlVerifySSL()
    {
        return $this->curlVerifySSL;
    }

    /**
     * @return string
     */
    public function getCheckoutType()
    {
        return $this->checkoutType === 'hpp' ? 'hpp' : 'iframe';
    }

    /**
     * @return false|string
     */
    public function getPaypalEnabled()
    {
        return $this->paypalEnabled;
    }

    /**
     * @return false|string
     */
    public function getPaypalContractId()
    {
        return $this->paypalContractId;
    }

    /**
     * @return false|string
     */
    public function getThemeId()
    {
        return $this->themeId;
    }


    /**
     * @return false|string
     */
    public function getCardFraudProtectionEnabled()
    {
        return $this->cardFraudProtectionEnabled;
    }

    /**
     * @return false|string
     */
    public function getCardFraudProtectionContractId()
    {
        return $this->cardFraudProtectionContractId;
    }

    /**
     * @return string
     */
    public function getTransactionType(): string
    {
        return $this->transactionType === 'PRE_AUTH' ? 'PRE_AUTH' : 'FINAL_AUTH';
    }

    /**
     * Capture 'true' only for 'SALE', 'false' for 'AUTH, PRE_AUTH'
     * @return bool
     */
    public function getCapture(): bool
    {
        if (!$this->transactionType){
            return true;
        }
        return $this->transactionType === 'SALE';
    }

    /**
     * @return false|string
     */
    public function getVippsEnabled()
    {
        return $this->vippsEnabled;
    }

    /**
     * @return false|string
     */
    public function getVippsSCALevel()
    {
        return $this->vippsSCALevel;
    }

    /**
     * @return false|string
     */
    public function getVippsContractId()
    {
        return $this->vippsContractId;
    }

    /**
     * @return false|string
     */
    public function getVippsThreeDSContractId()
    {
        return $this->vippsThreeDSContractId;
    }

    /**
     * @return false|string
     */
    public function getGpp2Enabled()
    {
        return $this->gpp2Enabled;
    }

    /**
     * @return false|string
     */
    public function getGpp2ContractId()
    {
        return $this->gpp2ContractId;
    }

    /**
     * @return false|string
     */
    public function getMobilePayEnabled()
    {
        return $this->mobilePayEnabled;
    }

    /**
     * @return false|string
     */
    public function getMobilePaySCALevel()
    {
        return $this->mobilePaySCALevel;
    }

    /**
     * @return false|string
     */
    public function getMobilePayContractId()
    {
        return $this->mobilePayContractId;
    }

    /**
     * @return false|string
     */
    public function getMobilePayThreeDSContractId()
    {
        return $this->mobilePayThreeDSContractId;
    }

    /**
     * @return false|string
     */
    public function getAbsInstallmentsEnabled()
    {
        return $this->absInstallmentsEnabled;
    }

    /**
     * @param $total
     * @return int
     */
    public function getAbsInstallments($total): int
    {
        $installments = json_decode($this->absInstallments, true);
        foreach ($installments['nr'] as $k => $number) {
            if ($number && !empty($installments['min'][$k]) && !empty($installments['max'][$k])) {
                //ILS have two decimals, so we need to multiply with 100
                $min = $installments['min'][$k] * 100;
                $max = $installments['max'][$k] * 100;
                if ($min < $total && $max >= $total) {
                    return $number;
                }
            }
        }
        return 0;
    }

    /**
     * @return false|string
     */
    public function getGiftCardEnabled()
    {
        return $this->giftCardEnabled;
    }


    /**
     * @return false|string
     */
    public function getGiftCardContractId()
    {
        return $this->giftCardContractId;
    }


}
