<?php

class Verifone_Helper
{
    const REFUND_STATUS_NEW = 1;
    const REFUND_STATUS_PROCESSED = 2;

    private $mobile_detect;
    private $hasErrors = false;
    private $errorBag = [];

    public function __construct()
    {
        $this->mobile_detect = new Mobile_Detect();
        $_SESSION['vf_flash'] = [];
    }

    public function getDeviceType(): string
    {
        $device_type = 'S';
        if ($this->mobile_detect->isMobile()) {
            $device_type = 'P';
        } elseif ($this->mobile_detect->isTablet()) {
            $device_type = 'T';
        }

        return $device_type;
    }

    /**
     * Check if a string is a valid UUID
     *
     * @param $key
     * @param $value
     *
     * @return void
     */
    public function uuid($key, $value)
    {

        if (strlen($value) &&
            (!is_string($value) ||
                preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/', $value) !== 1)) {
            $this->hasErrors = true;
            $this->errorBag[$key][] = 'You must provide a valid UUID value format!';
        }
    }

    public function required($key, $value)
    {
        if (empty($value)) {
            $this->hasErrors = true;
            $this->errorBag[$key][] = 'This field is required!';
        }
    }

    public function checkInstallments($installments)
    {
        foreach ($installments['min'] as $key => $installment) {
            if ($installment > $installments['max'][$key]) {
                $this->hasErrors = true;
                $this->errorBag['VERIFONE_ABS_INSTALLMENTS'] = 'Installment maximum must be greater than minimum';
            }
        }
    }

    /**
     * @return bool
     */
    public function hasErrors(): bool
    {
        return $this->hasErrors;
    }

    /**
     * @return array
     */
    public function getErrorBag(): array
    {
        return $this->errorBag;
    }

    /**
     * Format the given amount from FLOAT/STRING to INT and breaks it in the smallest unit of the given currency
     * @param  $amount
     * @param string $currency
     * @return int
     */
    public function calculateAmount($amount, string $currency): int
    {

        $_0decimals = ['XPF', 'XOF', 'XAF', 'VUV', 'VND', 'UYI', 'UGX', 'RWF', 'PYG', 'KRW', 'KMF', 'JPY', 'ISK', 'GNF', 'DJF', 'CLP', 'BIF'];
        $_3decimals = ['TND', 'OMR', 'LYD', 'KWD', 'JOD', 'IQD', 'BHD'];
        $_4decimals = ['UYW', 'CLF'];
        $stringAmount = (string)$amount;

        switch (strtoupper($currency)) {
            case in_array($currency, $_0decimals):
                $multiplier = 1;
                break;
            case in_array($currency, $_3decimals):
                $multiplier = 1000;
                break;
            case in_array($currency, $_4decimals):
                $multiplier = 10000;
                break;
            default: // for 2 decimals for the rest of currencies (vast majority)
                $multiplier = 100;
                break;
        }
        $newAmount = $multiplier * $stringAmount;
        $newAmount = (string)$newAmount;

        return (int)$newAmount;
    }

}
