<?php

class Verifone_Refund extends Verifone_Api_Entity
{


    protected $refund_params;
    protected $helper;
    protected $currency;

    /**
     * @throws Exception
     */
    public function __construct($amount, string $currency, Verifone_Helper $helper)
    {
        $this->currency = $currency;
        $this->helper = $helper;
        $this->buildData($amount);
    }

    /**
     * @throws Exception
     */
    private function buildData($amount)
    {

        $this->refund_params = ['amount' => $this->helper->calculateAmount($amount, $this->currency)];
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return $this->refund_params;
    }

    /**
     * @return false|string
     */
    public function toJson(): string
    {
        return json_encode($this->refund_params);
    }

}
