$(document).ready(function () {

    const setupModal = $('#autoSetupModal');

    if ($('#VERIFONE_USER_ID').val().length !== 36) {
        setupModal.modal('show');
        $(".modal-footer .text-danger").hide();
        $(".modal-footer .text-success").show();
    } else {
        $(".modal-footer .text-danger").show();
        $(".modal-footer .text-success").hide();
    }

    $('body').on('click', '#autoSetup', function (e) {
        e.preventDefault();
        setupModal.modal('show');
    });

    $('body').on('click', '#startSetup', function (e) {
        e.preventDefault();
        let self = $(this);
        $('.error').remove();
        $('.border-red').removeClass('border-red');
        let postData = {
            user_id: $('#as_VERIFONE_USER_ID').val(),
            api_key: $('#as_VERIFONE_API_KEY').val(),
            env: $('#as_VERIFONE_MODE_TEST').is(':checked') ? 'live' : 'test',
            region: $('#as_VERIFONE_REGION').val(),
        };
        if (postData.user_id.length !== 36) {
            $('#as_VERIFONE_USER_ID').addClass('border-red');
            $('#as_VERIFONE_USER_ID').parent().append(' <small class="text-danger error">The UserId must be a valid UUID!</small>')
            return false;
        }
        if (postData.api_key.length < 20) {
            $('#as_VERIFONE_API_KEY').addClass('border-red');
            $('#as_VERIFONE_API_KEY').parent().append(' <small class="text-danger error">The ApiKey is not valid!</small>')
            return false;
        }
        $.ajax({
            url: $('#autoSetupModal').data('url'),
            method: 'POST',
            dataType: 'json',
            cache: false,
            data: postData,
            beforeSend: function (xhr) {
                self.html('<span class="loader"></span>Processing').attr('disabled', true);
            }
        }).done(function (response) {
            if (response.status) {
                $('#VERIFONE_USER_ID').val(postData.user_id);
                $('#VERIFONE_API_KEY').val(postData.user_id);
                $('#VERIFONE_MODE_TEST').val(postData.env).trigger('change');
                $('#VERIFONE_REGION').val(postData.region).trigger('change');
                alert(response.message);
                $('#autoSetupModal').modal('hide');
                setTimeout(function () {
                    // location.reload(true);
                    // Simulate a mouse click:
                    window.location.href = location.href;
                }, 500)
            } else {
                alert(response.message)
            }

        }).fail(function (response) {
            console.error(response);
            alert(response.responseJSON.message)
        }).always(function () {
            self.html('Continue').attr('disabled', false);
        })
    });

});
