<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
{literal}
    <style>
        .bootstrap .tab-content > .active {
            display: block;
            background: #fff;
            padding: 30px;
        }

        .loader {
            border: 1px solid #fff;
            border-radius: 50%;
            border-top: 1px solid #00aff0;
            width: 13px;
            height: 13px;
            display: inline-block;
            margin-right: 5px;
            -webkit-animation: spin 1.5s linear infinite; /* Safari */
            animation: spin 1.5s linear infinite;
        }

        /* Safari */
        @-webkit-keyframes spin {
            0% {
                -webkit-transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
            }
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }

        .bootstrap .nav-tabs > li {
            width: 20%;
            text-align: center;

        }

        .bootstrap .nav-tabs li a:focus {
            outline: none;
        }

        .bootstrap .nav-tabs li a {
            font-weight: 400;
            color: #0A246A;
        }

        #verifoneContainer .alert {
            margin-bottom: 0;
        }

        .bootstrap .nav-tabs > li > a,
        .bootstrap .nav-tabs > li.active > a, .bootstrap .nav-tabs > li.active > a:focus, .bootstrap .nav-tabs > li.active > a:hover {
            border: none;
        }

        .child {
            display: none;
            margin: 15px 0 0 30px;
        }

        #alternative .parent {
            margin-bottom: 25px;
            border-bottom: 1px solid #ddd;
        }

        #verifoneContainer ul.defaultList {
            list-style: initial;
            padding-left: 10px;
        }

        #verifoneContainer ul {
            list-style: none;
            margin: 0;
            padding-left: 0;
        }

        .fixed-width-lg-x2 {
            width: 350px !important;
        }

        .bootstrap .purpleOff input:last-of-type:checked ~ a {
            background-color: #9d55d9;
            border: 1px solid #9d55d9;
        }

        .alerts {
            background: #fff;
            padding: 15px;
            margin-bottom: 15px;
        }

        #verifoneContainer .inline-radio label {
            display: inline-block;
            line-height: 26px;
            margin-right: 1%;
            cursor: pointer;
            padding: 0 10px;
            text-align: center;
            width: 31%;
            background: #dbd4d47a;
            border-radius: 4px;
        }
        .error{
            display: block;
        }

        .border-red {
            border-color: red;
        }
    </style>
    <script>

        $(document).ready(function () {
            $('body').on('click', '.toggle', function () {
                let self = $(this),
                    child = self.closest('.parent').find('.child').first(),
                    elems = self.parent().find('input');
                // this if/else is flipped because the values update after this check ...
                for (let i = 0; i < elems.length; i++) {
                    if (elems[i].checked === true) {
                        child.hide();
                    } else {
                        child.show();
                    }
                }
            });

            let checkboxes = $('.enable');
            for (let i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    if (checkboxes[i].value == 1) {
                        $(checkboxes[i]).closest('.parent').find('.child').first().show();
                    } else {
                        $(checkboxes[i]).closest('.parent').find('.child').first().hide();
                    }
                }
            }
        });

    </script>
{/literal}
<div class="row" id="verifoneContainer">
    <div class="col-sm-12 col-md-10 col-lg-8 col-md-offset-1 col-lg-offset-2">
        <div class="alerts">
            <div class="alert alert-warning">
                {l s='Register this web hook to your Verifone Account to get your orders status updated:' mod='verifone'} <strong>{$webhookUrl}</strong>
            </div>
        </div>

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active"><a href="#verifone" aria-controls="verifone" role="tab" data-toggle="tab">
                    {l s='Account settings' mod='verifone'}
                </a></li>
            <li role="presentation"><a href="#display" aria-controls="display" role="tab" data-toggle="tab">
                    {l s='Display settings' mod='verifone'}
                </a></li>
            <li role="presentation"><a href="#card" aria-controls="card" role="tab" data-toggle="tab">
                    {l s='Card settings' mod='verifone'}
                </a></li>
            <li role="presentation"><a href="#alternative" aria-controls="alternative" role="tab" data-toggle="tab">
                    {l s='Alternative payments' mod='verifone'}
                </a></li>
            <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">
                    {l s='Advanced settings' mod='verifone'}
                </a></li>
        </ul>
        <form class="defaultForm form-horizontal verifone" name="verifoneForm" id="verifoneForm" action="{$action}" method="post" enctype="multipart/form-data" novalidate="">
            <!-- Tab panes -->
            <div class="tab-content">
                {include file='module:verifone/views/templates/back/tabs/verifone.tpl'}
                {include file='module:verifone/views/templates/back/tabs/display.tpl'}
                {include file='module:verifone/views/templates/back/tabs/card.tpl'}
                {include file='module:verifone/views/templates/back/tabs/alternative.tpl'}
                {include file='module:verifone/views/templates/back/tabs/advanced.tpl'}
            </div>
            <div class="row" style="margin-bottom: 50px;">
                <div class="col-sm-12 text-center" style="margin-top: 15px;">
                    <div style="background: #fff; padding: 15px;">
                        <button type="submit" value="1" class="btn btn-success" name="submitverifone">
                            <i class="process-icon-save"></i>{l s='Save changes' mod='verifone'}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
