<div class="modal fade" id="autoSetupModal" tabindex="-1" role="dialog" data-url="{$autoSetupUrl}"
     aria-labelledby="autoSetupModal" aria-hidden="false" data-backdrop="static">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel">Auto Setup Tool</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: relative; top: -50px;">
                    <span aria-hidden="true">&times;</span>
                </button>
                <p> This tool will attempt to configure your Verifone account settings. Please input the necessary information below.
                    <a href="https://verifone.cloud/docs/online-payments/getting-started/api-authentication/obtaining-api-keys" target="_blank">Obtain API Keys</a>
                </p>
            </div>
            <div class="modal-body">
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="as_VERIFONE_MODE_TEST">Choose environment</label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="checkbox"
                               class="toggle-btn"
                               name="as_VERIFONE_MODE" value="live"
                               id="as_VERIFONE_MODE_TEST"
                               data-size="small"
                               data-onstyle="primary"
                               data-offstyle="info"
                               data-toggle="toggle"
                               data-width="250"
                               data-height="0"
                               data-on="LIVE"
                               data-off="TEST MODE (CST)">
                        <br/>
                        <small class="text-muted"> Use the Verifone testing environment (CST) to test the integration if you have an account set up in the CST environment.</small>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="as_VERIFONE_USER_ID">User ID <span class="text-danger">*</span> </label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="text" name="as_VERIFONE_USER_ID" class="form-control"
                               placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002" id="as_VERIFONE_USER_ID">
                        <small class="text-muted">The user id of the user that generated the API Key in Verifone Central.
                            You can find it in your Verifone Central account, under Profile→ API Keys. (mandatory)</small>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="as_VERIFONE_API_KEY">Api key <span class="text-danger">*</span> </label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="text" name="as_VERIFONE_API_KEY" class="form-control" required id="as_VERIFONE_API_KEY"
                               placeholder="aSVrrDTkYesTTbmxeDNNHreBeyPPckdZUcdq">
                        <small class="text-muted">The value of the public API Key you created in Verifone Central.</small>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="as_VERIFONE_REGION">Verifone account region</label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <select class="select" name="as_VERIFONE_REGION" id="as_VERIFONE_REGION" style="width: 100%">
                            <option value="EMEA">EMEA (Europe, Middle East, Africa)</option>
                            <option value="NA">NA (US)</option>
                            <option value="NZAU">NZ(New Zealand)</option>
                            <option value="AU">AU (Australia)</option>
                        </select>
                        <small class="text-muted">The region in which your Verifone account is created. Check your Verifone Central access URL if in doubt.</small>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="startSetup">Continue</button>
                <p class="text-right text-success">
                    <a href="https://www.verifone.com/en/global/contact-sales" target="_blank">I don't have a Verifone account!</a>
                </p>
                <p class="text-right text-danger">
                    <span class="fas fa-info-circle"></span>
                    Clicking <span class="text-primary">Continue</span> will override your current settings
                </p>
            </div>
        </div>
    </div>
</div>
