<div role="tabpanel" class="tab-pane" id="card">
    <div class="parent">
        <div class="row form-group">
            <div class="col-md-3 col-sm-4 text-right">
                <label for="VERIFONE_CARD_ENABLED">Card payments</label>
            </div>
            <div class="col-md-9 col-sm-8">
                <input type="checkbox"
                       class="toggle-btn enable"
                       name="VERIFONE_CARD_ENABLED" value="1"
                       id="VERIFONE_CARD_ENABLED"
                        {($data['VERIFONE_CARD_ENABLED'] === '1') ? 'checked' : ''}
                       data-size="small"
                       data-onstyle="success"
                       data-offstyle="danger"
                       data-toggle="toggle"
                       data-width="100"
                       data-on="Enabled"
                       data-off="Disabled">
                <br/>
            </div>
        </div>
        <div class="child">
            <div class="row form-group">
                <div class="col-md-3 col-sm-4 text-right">
                    <label for="VERIFONE_PAYMENT_CONTRACT_ID">Payment contract ID <span class="text-danger">*</span>
                    </label>
                </div>
                <div class="col-md-9 col-sm-8">
                    <input type="text" name="VERIFONE_PAYMENT_CONTRACT_ID" class="form-control"
                           id="VERIFONE_PAYMENT_CONTRACT_ID" placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                           value="{( !empty($data['VERIFONE_PAYMENT_CONTRACT_ID'])) ? $data['VERIFONE_PAYMENT_CONTRACT_ID'] : ''}">
                    {if isset($vf_errors['VERIFONE_PAYMENT_CONTRACT_ID']) && !empty($vf_errors['VERIFONE_PAYMENT_CONTRACT_ID'])}
                        <ul>
                            {foreach $vf_errors['VERIFONE_PAYMENT_CONTRACT_ID'] as $error}
                                <li><small class="text-danger">{$error}</small></li>
                            {/foreach}
                        </ul>
                    {else}
                        <small class="text-muted">Find it on your Payment Provider Contract page for the contract
                            enabling credit card payments.</small>
                    {/if}
                </div>
            </div>
            <div class="parent">
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="VERIFONE_3DS_ENABLED">Card 3DS</label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="checkbox"
                               class="toggle-btn enable"
                               name="VERIFONE_3DS_ENABLED" value="1"
                               id="VERIFONE_3DS_ENABLED"
                                {($data['VERIFONE_3DS_ENABLED'] === '1') ? 'checked' : ''}
                               data-size="small"
                               data-onstyle="success"
                               data-offstyle="danger"
                               data-toggle="toggle"
                               data-width="100"
                               data-on="Enabled"
                               data-off="Disabled">
                        <br/>
                        <small class="text-muted">The purpose of 3D-Secure is to safeguard the online payment by
                            applying an additional authentication step of the cardholder before sending an
                            authorization request to the card issuer.</small>
                    </div>
                </div>
                <div class="child">
                    <div class="row form-group">
                        <div class="col-md-3 col-sm-4 text-right">
                            <label for="VERIFONE_3DS_CONTRACT_ID">3DS contract ID <span class="text-danger">*</span>
                            </label>
                        </div>
                        <div class="col-md-9 col-sm-8">
                            <input type="text" name="VERIFONE_3DS_CONTRACT_ID" class="form-control"
                                   id="VERIFONE_3DS_CONTRACT_ID" placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                                   value="{( !empty($data['VERIFONE_3DS_CONTRACT_ID'])) ? $data['VERIFONE_3DS_CONTRACT_ID'] : ''}">
                            {if isset($vf_errors['VERIFONE_3DS_CONTRACT_ID']) && !empty($vf_errors['VERIFONE_3DS_CONTRACT_ID'])}
                                <ul>
                                    {foreach $vf_errors['VERIFONE_3DS_CONTRACT_ID'] as $error}
                                        <li><small class="text-danger">{$error}</small></li>
                                    {/foreach}
                                </ul>
                            {else}
                                <small class="text-muted">The 3DS Contract ID can be found in Verifone Central, under
                                    Administration → 3-D Secure Provider Contracts.</small>
                            {/if}
                        </div>
                    </div>
                </div>
            </div>
            <div class="parent">
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="VERIFONE_CARD_FRAUD_PROTECTION_ENABLED">Fraud protection</label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="checkbox"
                               class="toggle-btn enable"
                               name="VERIFONE_CARD_FRAUD_PROTECTION_ENABLED" value="1"
                               id="VERIFONE_CARD_FRAUD_PROTECTION_ENABLED"
                                {($data['VERIFONE_CARD_FRAUD_PROTECTION_ENABLED'] === '1') ? 'checked' : ''}
                               data-size="small"
                               data-onstyle="success"
                               data-offstyle="danger"
                               data-toggle="toggle"
                               data-width="100"
                               data-on="Enabled"
                               data-off="Disabled">
                        <br/>
                        <small class="text-muted">Enable the card fraud protection.</small>
                    </div>
                </div>
                <div class="child">
                    <div class="row form-group">
                        <div class="col-md-3 col-sm-4 text-right">
                            <label for="VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID">Fraud Contract ID
                                <span class="text-danger">*</span>
                            </label>
                        </div>
                        <div class="col-md-9 col-sm-8">
                            <input type="text" name="VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID" class="form-control"
                                   id="VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID"
                                   placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                                   value="{( !empty($data['VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID'])) ? $data['VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID'] : ''}">
                            {if isset($vf_errors['VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID']) && !empty($vf_errors['VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID'])}
                                <ul>
                                    {foreach $vf_errors['VERIFONE_CARD_FRAUD_PROTECTION_CONTRACT_ID'] as $error}
                                        <li><small class="text-danger">{$error}</small></li>
                                    {/foreach}
                                </ul>
                            {else}
                                <small class="text-muted">Ask your account manager for the fraud contract ID.</small>
                            {/if}
                        </div>
                    </div>
                </div>
            </div>


            <div class="parent">
                <div class="row form-group">
                    <div class="col-md-3 col-sm-4 text-right">
                        <label for="VERIFONE_ABS_INSTALLMENTS_ENABLED"> ABS installments</label>
                    </div>
                    <div class="col-md-9 col-sm-8">
                        <input type="checkbox"
                               class="toggle-btn enable"
                               name="VERIFONE_ABS_INSTALLMENTS_ENABLED" value="1"
                               id="VERIFONE_ABS_INSTALLMENTS_ENABLED"
                                {($data['VERIFONE_ABS_INSTALLMENTS_ENABLED'] === '1') ? 'checked' : ''}
                               data-size="small"
                               data-onstyle="success"
                               data-offstyle="danger"
                               data-toggle="toggle"
                               data-width="100"
                               data-on="Enabled"
                               data-off="Disabled">
                        <br/>
                        <small class="text-muted">Enable if you have a contract with ABS from <strong>Israel</strong> through Verifone and
                            wish to make use of it in your cart.</small>
                    </div>
                </div>
                <div class="child" style="margin: 15px 0 0 0">
                    <div class="row form-group ">
                        <div class="col-md-9 col-md-offset-3 text-center">
                            <table class="table table-borderless table-condensed text-center" id="installmentsTable">
                                <thead>
                                <tr>
                                    <th class="text-center">Min order amount (ILS)</th>
                                    <th class="text-center">Max order amount (ILS)</th>
                                    <th class="text-center">Maximum number of installments</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $installments['min'] as $key => $installment}
                                    {if (!empty($installment) && !empty($installments['max'][$key]) && !empty($installments['nr'][$key]))}
                                        <tr>
                                            <td><input type="text" class="form-control text-center" name="VERIFONE_ABS_INSTALLMENTS[min][]"
                                                       value="{($installment)}" readonly onkeypress="return onlyNumberKey(event)"></td>
                                            <td><input type="text" class="form-control text-center abs_max" name="VERIFONE_ABS_INSTALLMENTS[max][]"
                                                       value="{$installments['max'][$key]}" readonly onkeypress="return onlyNumberKey(event)"></td>
                                            <td><input type="text" class="form-control text-center abs_nr" name="VERIFONE_ABS_INSTALLMENTS[nr][]"
                                                       value="{$installments['nr'][$key]}" readonly onkeypress="return onlyNumberKey(event)"></td>
                                            <td>
                                                <button class="btn btn-xs btn-danger remove">Remove</button>
                                            </td>
                                        </tr>
                                    {/if}
                                {/foreach}
                                </tbody>
                            </table>
                            <button class="btn btn-default add" style="margin-top:25px">Add new</button>
                            {if isset($vf_errors['VERIFONE_ABS_INSTALLMENTS']) && !empty($vf_errors['VERIFONE_ABS_INSTALLMENTS'])}
                                <ul>
                                    <li><small class="text-danger">{$vf_errors['VERIFONE_ABS_INSTALLMENTS']}</small></li>
                                </ul>
                            {/if}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="parent">
        <div class="row form-group">
            <div class="col-md-3 col-sm-4 text-right">
                <label for="VERIFONE_GIFT_CARD_ENABLED">Gift Card </label>
            </div>
            <div class="col-md-9 col-sm-8">
                <input type="checkbox"
                       class="toggle-btn enable"
                       name="VERIFONE_GIFT_CARD_ENABLED" value="1"
                       id="VERIFONE_GIFT_CARD_ENABLED"
                        {($data['VERIFONE_GIFT_CARD_ENABLED'] === '1') ? 'checked' : ''}
                       data-size="small"
                       data-onstyle="success"
                       data-offstyle="danger"
                       data-toggle="toggle"
                       data-width="100"
                       data-on="Enabled"
                       data-off="Disabled">
                <br/>
            </div>
        </div>
        <div class="child">
            <div class="row form-group">
                <div class="col-md-3 col-sm-4 text-right">
                    <label for="VERIFONE_GIFT_CARD_CONTRACT_ID">Gift Card Contract Id
                        <span class="text-danger">*</span>
                    </label>
                </div>
                <div class="col-md-9 col-sm-8">
                    <input type="text" name="VERIFONE_GIFT_CARD_CONTRACT_ID" class="form-control"
                           id="VERIFONE_GIFT_CARD_CONTRACT_ID"
                           placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                           value="{( !empty($data['VERIFONE_GIFT_CARD_CONTRACT_ID'])) ? $data['VERIFONE_GIFT_CARD_CONTRACT_ID'] : ''}">
                    {if isset($vf_errors['VERIFONE_GIFT_CARD_CONTRACT_ID']) && !empty($vf_errors['VERIFONE_GIFT_CARD_CONTRACT_ID'])}
                        <ul>
                            {foreach $vf_errors['VERIFONE_GIFT_CARD_CONTRACT_ID'] as $error}
                                <li><small class="text-danger">{$error}</small></li>
                            {/foreach}
                        </ul>
                    {else}
                        <small class="text-muted">Ask your account manager for the Gift Card contract ID.</small>
                    {/if}
                </div>
            </div>
        </div>
    </div>
    <div class="parent">
        <div class="row form-group">
            <div class="col-md-3 col-sm-4 text-right">
                <label for="VERIFONE_PLCC_ENABLED">Plcc</label>
            </div>
            <div class="col-md-9 col-sm-8">
                <input type="checkbox"
                       class="toggle-btn enable"
                       name="VERIFONE_PLCC_ENABLED" value="1"
                       id="VERIFONE_PLCC_ENABLED"
                        {($data['VERIFONE_PLCC_ENABLED'] === '1') ? 'checked' : ''}
                       data-size="small"
                       data-onstyle="success"
                       data-offstyle="danger"
                       data-toggle="toggle"
                       data-width="100"
                       data-on="Enabled"
                       data-off="Disabled">
            </div>
        </div>
        <div class="child">
            <div class="row form-group">
                <div class="col-md-3 col-sm-4 text-right">
                    <label for="VERIFONE_PLCC_CONTRACT_ID">PLCC contract ID <span class="text-danger">*</span> </label>
                </div>
                <div class="col-md-9 col-sm-8">
                    <input type="text" name="VERIFONE_PLCC_CONTRACT_ID" class="form-control" id="VERIFONE_PLCC_CONTRACT_ID"
                           placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                           value="{( !empty($data['VERIFONE_PLCC_CONTRACT_ID'])) ? $data['VERIFONE_PLCC_CONTRACT_ID'] : ''}">
                    {if isset($vf_errors['VERIFONE_PLCC_CONTRACT_ID']) && !empty($vf_errors['VERIFONE_PLCC_CONTRACT_ID'])}
                        <ul>
                            {foreach $vf_errors['VERIFONE_PLCC_CONTRACT_ID'] as $error}
                                <li><small class="text-danger">{$error}</small></li>
                            {/foreach}
                        </ul>
                    {else}
                        <small class="text-muted">The ID can be found in Verifone Central, under Administration → Payment Provider
                            Contracts, after selecting the contract available for PLCC as a service provider.</small>
                    {/if}
                </div>
            </div>
        </div>
    </div>
</div>

{literal}
    <script>
        jQuery(document).ready(function () {
            const body = $('body');
            body.on('click', '.remove', function (e) {
                e.preventDefault();
                jQuery(this).closest('tr').remove();
            })
            body.on('click', '.add', function (e) {
                e.preventDefault();
                let row,
                    lowestValue = '',
                    tBody = jQuery('#installmentsTable tbody'),
                    installments = tBody.find('tr');
                if (installments.length) {
                    //get the last row of installments as jQuery object
                    let lastElementOfArray = jQuery(installments[installments.length - 1]);
                    let inputs = lastElementOfArray.find('input'),
                        min = parseInt(jQuery(inputs[0]).val()),
                        max = parseInt(jQuery(inputs[1]).val()),
                        nr = parseInt(jQuery(inputs[2]).val());

                    if (!min || !max || !nr) {
                        alert('Please fill all inputs before adding new installment!');
                        return false;
                    }
                    if (min >= max) {
                        alert('Maximum order amount must be greater than minimum!');
                        return false;
                    }
                    lowestValue = 'value="' + max + '" readonly';
                }
                tBody.find('input').attr('readonly', true);

                row = '<tr><td><input type="text" class="form-control text-center" ' + lowestValue + ' name="VERIFONE_ABS_INSTALLMENTS[min][]" onkeypress="return onlyNumberKey(event)"></td>';
                row += '<td><input type="text" class="form-control text-center abs_max"  name="VERIFONE_ABS_INSTALLMENTS[max][]" onkeypress="return onlyNumberKey(event)"></td>';
                row += '<td><input type="text" class="form-control text-center abs_nr"  name="VERIFONE_ABS_INSTALLMENTS[nr][]" onkeypress="return onlyNumberKey(event)"></td>';
                row += '<td><button class="btn btn-xs btn-danger remove">Remove</button></td></tr>';

                tBody.append(row);
            })

        });

        function onlyNumberKey(evt) {
            const ASCIICode = (evt.which) ? evt.which : evt.keyCode;
            return !(ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57));
        }
    </script>
{/literal}