<div role="tabpanel" class="tab-pane active" id="verifone">
    <div class="row form-group text-right">
        <button class="button btn-sm btn-success" id="autoSetup" style="border: none">
            <i class="fa-light fa-gear mr-2"></i> Auto Setup Tool
        </button>
    </div>
    <div class="row form-group">
        <div class="col-md-3 col-sm-4 text-right">
            <label for="VERIFONE_MODE_TEST">Choose environment</label>
        </div>
        <div class="col-md-9 col-sm-8">
            <input type="checkbox"
                   class="toggle-btn"
                   name="VERIFONE_MODE" value="live"
                   id="VERIFONE_MODE_TEST"
                   {($data['VERIFONE_MODE'] ==='live')?'checked':''}
                   data-size="small"
                   data-onstyle="primary"
                   data-offstyle="info"
                   data-toggle="toggle"
                   data-width="250"
                   data-height="0"
                   data-on="LIVE"
                   data-off="TEST MODE (CST)">
            <br />
            <small class="text-muted"> Use the Verifone testing environment (CST) to test the integration, if you have an account set up in the CST environment.</small>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-3 col-sm-4 text-right">
            <label for="VERIFONE_USER_ID">User ID <span class="text-danger">*</span> </label>
        </div>
        <div class="col-md-9 col-sm-8">
            <input type="text" name="VERIFONE_USER_ID" class="form-control" placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002" id="VERIFONE_USER_ID"
                   value="{( !empty($data['VERIFONE_USER_ID'])) ? $data['VERIFONE_USER_ID'] : ''}">
            {if isset($vf_errors['VERIFONE_USER_ID']) && !empty($vf_errors['VERIFONE_USER_ID'])}
                <ul>
                    {foreach $vf_errors['VERIFONE_USER_ID'] as $error}
                        <li><small class="text-danger">{$error}</small></li>
                    {/foreach}
                </ul>
            {else}
                <small class="text-muted">The user id of the user that generated the API Key in Verifone Central. You can find it in your Verifone Central account, under Profile → API Keys.
                    (mandatory)</small>
            {/if}
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-3 col-sm-4 text-right">
            <label for="VERIFONE_API_KEY">Api key <span class="text-danger">*</span> </label>
        </div>
        <div class="col-md-9 col-sm-8">
            <input type="text" name="VERIFONE_API_KEY" class="form-control" required id="VERIFONE_API_KEY" placeholder="aSVrrDTkYesTTbmxeDNNHreBeyPPckdZUcdq"
                           value="{( !empty($data['VERIFONE_API_KEY'])) ? $data['VERIFONE_API_KEY'] : ''}">
            {if isset($vf_errors['VERIFONE_API_KEY']) && !empty($vf_errors['VERIFONE_API_KEY'])}
                <ul>
                    {foreach $vf_errors['VERIFONE_API_KEY'] as $error}
                        <li><small class="text-danger">{$error}</small></li>
                    {/foreach}
                </ul>
            {else}
                <small class="text-muted">The value of the public API Key you created in Verifone Central.</small>
            {/if}
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-3 col-sm-4 text-right">
            <label for="VERIFONE_ENTITY_ID">Organisation ID <span class="text-danger">*</span> </label>
        </div>
        <div class="col-md-9 col-sm-8">
            <input type="text" name="VERIFONE_ENTITY_ID" class="form-control" required id="VERIFONE_ENTITY_ID" placeholder="5ee2f5c4-97dc-11ed-a8fc-0242ac120002"
                   value="{( !empty($data['VERIFONE_ENTITY_ID'])) ? $data['VERIFONE_ENTITY_ID'] : ''}">
            {if isset($vf_errors['VERIFONE_ENTITY_ID']) && !empty($vf_errors['VERIFONE_ENTITY_ID'])}
                <ul>
                    {foreach $vf_errors['VERIFONE_ENTITY_ID'] as $error}
                        <li><small class="text-danger">{$error}</small></li>
                    {/foreach}
                </ul>
            {else}
                <small class="text-muted"> The organisation ID can be found in Verifone Central, under Administration → Organisations.</small>
            {/if}
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-3 col-sm-4 text-right">
            <label for="VERIFONE_REGION">Verifone account region</label>
        </div>
        <div class="col-md-9 col-sm-8">
            <select class="select" name="VERIFONE_REGION" id="VERIFONE_REGION" style="width: 100%">
                <option value="EMEA" {( ($data['VERIFONE_REGION']) === 'EMEA') ? 'selected' : ''}>EMEA (Europe, Middle East, Africa)</option>
                <option value="NA" {( ($data['VERIFONE_REGION']) === 'NA') ? 'selected' : ''}>NA (US)</option>
                <option value="NZAU" {( ($data['VERIFONE_REGION']) === 'NZAU') ? 'selected' : ''}>NZ (New Zealand)</option>
                <option value="AU" {( ($data['VERIFONE_REGION']) === 'AU') ? 'selected' : ''}>AU (Australia)</option>
            </select>
            <small class="text-muted">The region in which your Verifone account is created. Check your Verifone Central access URL if in doubt.</small>
        </div>
    </div>
</div>
{include file='module:verifone/views/templates/back/auto_setup.tpl'}
