<script>
    {literal}
    jQuery(document).ready(function () {

        jQuery('body').on('click', '.btn-manualCapture', function (e) {
            e.preventDefault();
            jQuery('#manualCapture').toggle();
        });


        jQuery('body').on('click', '.btn-verifone', function (e) {
            e.preventDefault();
            let parentForm = jQuery(this).closest('form');
            jQuery('.btn-verifone').attr('disabled', true);

            $.ajax({
                url: parentForm.attr('action'),
                method: 'POST',
                data: parentForm.serialize()
            }).done(function (xhr, status, response) {
                let result = JSON.parse(response.responseText);
                if (result.status) {
                    jQuery('#verifoneManualCaptureContainer').html('<div style="background: #64d064; padding: 10px; color: #fff; margin: 15px 0; border-radius: 5px;">' + result.message + '</div>');
                } else {
                    alert(result.message);
                    console.error(response);
                }
            }).fail(function (xhr, status, response) {
                alert('Something went wrong! Please try again later.');
                console.error(response);
                jQuery('.btn-verifone').attr('disabled', false);
            });
        })
    })
    {/literal}
</script>

<div id="verifoneManualCaptureContainer">
    <div class="mb-2">
        <button type="button" class="btn btn-action btn-manualCapture"
                data-allow="{$transaction['transaction_status']}">
            <i class="material-icons" aria-hidden="true">art_track</i>{l s='Manual capture' mod='verifone'}
        </button>
    </div>
    <div id="manualCapture" style="padding: 10px 25px; border: 1px solid #fff; margin: 10px 0;display: none">
        <div class="row">
            <div class="col-sm-6">
                <form action="{$captureUrl}" method="POST">
                    <input type="hidden" name="type" value="partial">
                    <input type="hidden" name="transaction_id" value="{$transaction_id}">
                    <input type="hidden" name="order_id" value="{$order->id}">
                    <div class="form-group row">
                        <div class="col-md-7">
                            <label for="amount" class="form-control-label">{l s='Capture partial amount' mod='verifone'}</label>
                            <input type="number" id="amount" name="amount" class="form-control" step="0.01"
                                   value="{$order->getTotalPaid()}" min="0" max="{$order->getTotalPaid()}">
                        </div>
                        <div class="col-md-5">
                            <button type="submit" class="btn btn-action btn-verifone" style="margin-top: 25px;">
                                {l s='Partial capture' mod='verifone'}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-sm-6" style="border-left: 1px solid #fff">
                <form action="{$captureUrl}" method="POST">
                    <input type="hidden" name="type" value="full">
                    <input type="hidden" name="transaction_id" value="{$transaction_id}">
                    <input type="hidden" name="order_id" value="{$order->id}">
                    <label for="amount" class="form-control-label ">{l s='Capture entire order amount' mod='verifone'}</label> <br/>
                    <button type="submit" class="btn btn-action btn-verifone">{l s='Full capture' mod='verifone'}</button>
                </form>
            </div>
        </div>
    </div>
</div>
